/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas.exportaciones;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.convertidores.BooleanNegativeConverter;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.exportacion.valores.ModeloValoresClienteExportacion;
import ec.gob.sri.dimm.ats.modelo.obj.exportacion.ClienteExportacion;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.ComponenteFiscalidad;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;

public class PaginaCliente
extends PaginaAsistente
implements VistaModelo<ClienteExportacion>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private boolean editando;
    private ModeloValoresClienteExportacion modeloValores;
    private ClienteExportacion modeloDatos;
    private ComboViewer cvTipoIdCliente;
    private Composite cParteRelacionada;
    private ComponenteFiscalidad compFiscalidad;
    private Text txtIdCliente;
    private Button btnSi;
    private Button btnNo;
    private Button btnNoRegFis;
    private Button btnSiRegFis;
    private Text txtRazonSocial;
    private ComboViewer cvTipoDeCliente;
    private Label lblRazonSocial;
    private Label lblTipoDeCliente;
    private Combo cmbTipoCliente;
    private Periodo periodo;
    private Composite compositePago;
    private Label lblesPagoA;
    private Composite compositeRegFis;

    public PaginaCliente(boolean editando, Periodo periodo) {
        super(PaginaCliente.class.getName(), "Detalle Exportaci\u00f3n", "Especifique la informaci\u00f3n correspondiente");
        this.setDescription("Especifique la informaci\u00f3n correspondiente al Cliente");
        this.setTitle("Cliente");
        this.editando = editando;
        this.periodo = periodo;
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresClienteExportacion();
        this.modeloValores.inicializar();
    }

    public void setModeloDatos(ClienteExportacion modeloDatos) {
        this.modeloDatos = modeloDatos;
        this.compFiscalidad = new ComponenteFiscalidad(modeloDatos.getPagoLocalExterior(), this.periodo);
    }

    public void procesarModeloDatos() {
        String codigoIdentificacion = this.modeloDatos.getTipoIdentificacion();
        this.seleccionarIdentificacionEnComboEnModoEdicion(codigoIdentificacion);
        String tipoCliente = this.modeloDatos.getTipoProveedor();
        this.seleccionarTipoDeClienteEnComboModoEdicion(tipoCliente);
        this.compFiscalidad.inicializarViews();
        this.habilitarRegimenFiscalPreferenteDesdeMarzo2015HastaAbril2016();
        this.compFiscalidad.determinarTipoRegimen();
        if (this.editando) {
            this.compFiscalidad.habilitarConvenioYRetencionParaPagoExteriorModoEdicion(true);
        } else {
            this.compFiscalidad.habilitarPagoExteriorModuloDeExportaciones(true);
        }
        ListenerValidacionModeloPaginaAsistente listener = new ListenerValidacionModeloPaginaAsistente((InformacionValidable)this.modeloDatos, (PaginaAsistente)this);
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)listener);
        this.modeloDatos.getPagoLocalExterior().addPropertyChangeListener((PropertyChangeListener)listener);
        this.modeloDatos.getPagoLocalExterior().getFiscalidad().addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void seleccionarTipoDeClienteEnComboModoEdicion(String tipoCliente) {
        ElementoNombreValor tipoProveedor = this.modeloValores.obtenerClaseDeContribuyente(tipoCliente);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoDeCliente, (Object)tipoProveedor);
    }

    private void seleccionarIdentificacionEnComboEnModoEdicion(String codigoIdentificacion) {
        if (codigoIdentificacion == null) {
            this.cParteRelacionada.setVisible(false);
            this.btnSiRegFis.setEnabled(false);
            this.btnNoRegFis.setEnabled(false);
        }
        ElementoNombreValor tipoIdentificacion = this.modeloValores.obtenerTipoIdentificacion(codigoIdentificacion);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoIdCliente, (Object)tipoIdentificacion);
    }

    private void habilitarRegimenFiscalPreferenteDesdeMarzo2015HastaAbril2016() {
        this.btnSiRegFis.setEnabled(this.periodo.isPeriodoDeAnexoDesdeMarzo2015() && this.periodo.isAnexoEnPeriodoHastaAbril2016());
        this.btnNoRegFis.setEnabled(this.periodo.isPeriodoDeAnexoDesdeMarzo2015() && this.periodo.isAnexoEnPeriodoHastaAbril2016());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblTipoIdCliente = new Label(container, 0);
        GridData gd_lblTipoIdCliente = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTipoIdCliente.horizontalIndent = 3;
        lblTipoIdCliente.setLayoutData((Object)gd_lblTipoIdCliente);
        lblTipoIdCliente.setText("Tipo Id. Cliente");
        this.cvTipoIdCliente = new ComboViewer(container, 8);
        this.manejarSeleccionComboTipoIdProveedor();
        Combo combo_1 = this.cvTipoIdCliente.getCombo();
        GridData gd_combo_1 = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo_1.widthHint = 300;
        combo_1.setLayoutData((Object)gd_combo_1);
        Label lblNIdentificacionCliente = new Label(container, 0);
        GridData gd_lblNIdentificacionCliente = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNIdentificacionCliente.horizontalIndent = 3;
        gd_lblNIdentificacionCliente.widthHint = 155;
        lblNIdentificacionCliente.setLayoutData((Object)gd_lblNIdentificacionCliente);
        lblNIdentificacionCliente.setText("N\u00b0 Identificaci\u00f3n Cliente");
        this.txtIdCliente = new Text(container, 2048);
        this.txtIdCliente.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaCliente.this.txtIdCliente.selectAll();
            }
        });
        this.txtIdCliente.setTextLimit(13);
        GridData gd_txtIdCliente = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtIdCliente.widthHint = 100;
        this.txtIdCliente.setLayoutData((Object)gd_txtIdCliente);
        this.cParteRelacionada = new Composite(container, 0);
        this.cParteRelacionada.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridLayout gl_cParteRelacionada = new GridLayout(2, false);
        gl_cParteRelacionada.marginWidth = 0;
        this.cParteRelacionada.setLayout((Layout)gl_cParteRelacionada);
        Label lblParteRelacionada = new Label(this.cParteRelacionada, 0);
        GridData gd_lblParteRelacionada = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblParteRelacionada.widthHint = 270;
        lblParteRelacionada.setLayoutData((Object)gd_lblParteRelacionada);
        lblParteRelacionada.setText("\u00bfEs parte relacionada?");
        Composite composite = new Composite(this.cParteRelacionada, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.btnSi = new Button(composite, 16);
        this.btnSi.setText("SI");
        this.btnNo = new Button(composite, 16);
        this.btnNo.setText("NO");
        this.lblTipoDeCliente = new Label(container, 0);
        this.lblTipoDeCliente.setVisible(false);
        this.lblTipoDeCliente.setText("Tipo de Cliente");
        this.cvTipoDeCliente = new ComboViewer(container, 8);
        this.cmbTipoClienteSelectionChanged();
        this.cmbTipoCliente = this.cvTipoDeCliente.getCombo();
        this.cmbTipoCliente.setVisible(false);
        this.cmbTipoCliente.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblRazonSocial = new Label(container, 0);
        this.lblRazonSocial.setVisible(false);
        this.lblRazonSocial.setText("Raz\u00f3n Social");
        this.txtRazonSocial = new Text(container, 2048);
        this.txtRazonSocial.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        this.txtRazonSocial.setVisible(false);
        this.txtRazonSocial.setTextLimit(500);
        this.txtRazonSocial.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblInformacionPago = new Label(container, 0);
        lblInformacionPago.setFont(SWTResourceManager.getFont((String)"Segoe UI", (int)10, (int)1));
        lblInformacionPago.setText("Informaci\u00f3n de la Exportaci\u00f3n");
        new Label(container, 0);
        this.compositePago = new Composite(container, 0);
        GridData gd_compositePago = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_compositePago.widthHint = 562;
        this.compositePago.setLayout((Layout)new GridLayout(2, false));
        this.compositePago.setLayoutData((Object)gd_compositePago);
        boolean esExportacion = true;
        this.compFiscalidad.crearComponenteFiscalidad(this.compositePago, esExportacion);
        this.lblesPagoA = new Label(container, 0);
        GridData gd_lblesPagoA = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblesPagoA.widthHint = 300;
        this.lblesPagoA.setLayoutData((Object)gd_lblesPagoA);
        this.lblesPagoA.setText("\u00bfExportaci\u00f3n a para\u00edso fiscal, jurisdicci\u00f3n de menor\r\nimposici\u00f3n o r\u00e9gimen fiscal preferente?");
        this.compositeRegFis = new Composite(container, 0);
        this.compositeRegFis.setLayout((Layout)new GridLayout(2, false));
        this.btnSiRegFis = new Button(this.compositeRegFis, 16);
        this.btnSiRegFis.setText("SI");
        this.btnNoRegFis = new Button(this.compositeRegFis, 16);
        this.btnNoRegFis.setText("NO");
        this.m_bindingContext = this.initDataBindings();
        this.compFiscalidad.initDataBindingsFiscaldiad(this.m_bindingContext, (ObjetoModelo)this.modeloDatos);
        this.procesarModeloDatos();
    }

    private void cmbTipoClienteSelectionChanged() {
        this.cvTipoDeCliente.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor claseContribuyente = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (claseContribuyente != null) {
                    PaginaCliente.this.modeloDatos.setTipoProveedor((String)claseContribuyente.getValor());
                    PaginaCliente.this.modeloDatos.setDescripcionTipoProveedor(claseContribuyente.getNombre());
                }
            }
        });
    }

    public void manejarSeleccionComboTipoIdProveedor() {
        this.cvTipoIdCliente.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor tipoID = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (tipoID != null) {
                    PaginaCliente.this.renderizarParteRelacionadaEnBaseAlPeriodo((ElementoNombreValor<String>)tipoID);
                    PaginaCliente.this.modeloDatos.setTipoIdentificacion((String)tipoID.getValor());
                    PaginaCliente.this.modeloDatos.setDescripcionTipoIdentificacion(tipoID.getNombre());
                    PaginaCliente.this.mostrarTipoDeClienteYRazonSocialDesdeMayo2016((ElementoNombreValor<String>)tipoID);
                }
            }
        });
    }

    private void mostrarTipoDeClienteYRazonSocialDesdeMayo2016(ElementoNombreValor<String> tipoIdentificacion) {
        boolean esPasaporteYPeriodoDesdeMayo2016 = "P".equals(tipoIdentificacion.getValor()) && ((Iva)this.modeloDatos.getRaizModelo()).periodo.isAnexoEnPeriodoDesdeMayo2016();
        this.lblRazonSocial.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        this.txtRazonSocial.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        this.lblTipoDeCliente.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        this.cmbTipoCliente.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        if (!esPasaporteYPeriodoDesdeMayo2016) {
            this.txtRazonSocial.setText("");
            this.modeloDatos.setTipoProveedor(null);
            this.modeloDatos.setDescripcionTipoProveedor("");
        }
    }

    private void renderizarParteRelacionadaEnBaseAlPeriodo(ElementoNombreValor<String> tipoID) {
        boolean esRUCoPasaporte = "P".equals(tipoID.getValor()) | "R".equals(tipoID.getValor());
        boolean esPasaporte = "P".equals(tipoID.getValor());
        this.btnSiRegFis.setEnabled(esPasaporte && this.periodo.isAnexoEnPeriodoDesdeMarzo2015HastaAbril2016());
        this.btnNoRegFis.setEnabled(esPasaporte && this.periodo.isAnexoEnPeriodoDesdeMarzo2015HastaAbril2016());
        this.cParteRelacionada.setVisible(esRUCoPasaporte);
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoIdCliente.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoIdCliente.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposIdentificacionModeloValoresObserveList = PojoProperties.list((String)"tiposIdentificacionCliente").observe((Object)this.modeloValores);
        this.cvTipoIdCliente.setInput((Object)tiposIdentificacionModeloValoresObserveList);
        ISWTObservableValue observeTextTxtIdProveedorObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtIdCliente);
        IObservableValue identificacionModeloDatosObserveValue = BeanProperties.value((String)"identificacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtIdProveedorObserveWidget, identificacionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeSelectionButtonObserveWidget = WidgetProperties.selection().observe((Widget)this.btnSi);
        IObservableValue parteRelacionadaModeloDatosObserveValue = BeanProperties.value((String)"parteRelacionada").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeSelectionButtonObserveWidget, parteRelacionadaModeloDatosObserveValue, null, null);
        ISWTObservableValue observeSelectionButton_1ObserveWidget = WidgetProperties.selection().observe((Widget)this.btnNo);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
        strategy_1.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)observeSelectionButton_1ObserveWidget, parteRelacionadaModeloDatosObserveValue, strategy, strategy_1);
        ISWTObservableValue btnSiRegFisObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnSiRegFis);
        IObservableValue modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"pagoLocalExterior.pagoRegimenFiscal");
        bindingContext.bindValue((IObservableValue)btnSiRegFisObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue, null, null);
        ISWTObservableValue btnNoRegFisObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnNoRegFis);
        UpdateValueStrategy strategy_2 = new UpdateValueStrategy();
        strategy_2.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_3 = new UpdateValueStrategy();
        strategy_3.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnNoRegFisObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue, strategy_2, strategy_3);
        ObservableListContentProvider listContentProvider_2 = new ObservableListContentProvider();
        IObservableMap observeMap_2 = PojoObservables.observeMap((IObservableSet)listContentProvider_2.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoDeCliente.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_2));
        this.cvTipoDeCliente.setContentProvider((IContentProvider)listContentProvider_2);
        IObservableList modeloValoresClasesDeContribuyenteObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"clasesDeContribuyente");
        this.cvTipoDeCliente.setInput((Object)modeloValoresClasesDeContribuyenteObserveList);
        ISWTObservableValue txtRazonSocialObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtRazonSocial, (int)24);
        IObservableValue modeloDatosRazonSocialObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"razonSocial");
        bindingContext.bindValue((IObservableValue)txtRazonSocialObserveTextObserveWidget, modeloDatosRazonSocialObserveValue, null, null);
        ISWTObservableValue lblesPagoAObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.lblesPagoA);
        IObservableValue periodoAnexoEnPeriodoDesdeMarzo2015HastaAbril2016ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"anexoEnPeriodoDesdeMarzo2015HastaAbril2016");
        bindingContext.bindValue((IObservableValue)lblesPagoAObserveVisibleObserveWidget, periodoAnexoEnPeriodoDesdeMarzo2015HastaAbril2016ObserveValue, null, null);
        ISWTObservableValue compositeRegFisObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.compositeRegFis);
        bindingContext.bindValue((IObservableValue)compositeRegFisObserveVisibleObserveWidget, periodoAnexoEnPeriodoDesdeMarzo2015HastaAbril2016ObserveValue, null, null);
        return bindingContext;
    }
}

